#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	/// <summary>
	/// Summary description for CTRatioReport.
	/// </summary>
	[TestFixture]
	public class BOL_CTRatioReport : BaseTest 
	{
		private BOL.CTRatioReport _tstReport;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			this._tstReport = new BOL.CTRatioReport();
			this._tstReport.StartDate = System.DateTime.Now.AddYears(-1);
			this._tstReport.EndDate = System.DateTime.Now.AddYears(1);
		}	


		[Test]
		public void Ctor_Dates_Bools_Pass()
		{
			DateTime startDate = DateTime.Today.AddDays(-30);
			DateTime endDate = DateTime.Now;
			BOL.CTRatioReport tmpCTRR = new BOL.CTRatioReport(startDate,endDate,true,false);

			Assert.IsNotNull(tmpCTRR);
			Assert.AreEqual(startDate,tmpCTRR.StartDate,"StartDate");
			Assert.AreEqual(endDate.Date.AddHours(23).AddMinutes(59).AddSeconds(59),tmpCTRR.EndDate,"EndDate");
			Assert.AreEqual(true,tmpCTRR.IsMultiDivisional,"IsMultiDivisional");
			Assert.AreEqual(false,tmpCTRR.IsScheduled,"IsScheduled");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_Dates_Bools_Fail()
		{
		}

		[Test]
		public void IncludeDetailedReport_Pass()
		{
			bool tstValue = (!this._tstReport.IncludeDetailedReport);

			this._tstReport.IncludeDetailedReport = tstValue;

			Assert.IsTrue(this._tstReport.IncludeDetailedReport == tstValue);
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeDetailedReport_Fail()
		{
		}

		[Test]
		public void IncludePhysicianSummary_Pass()
		{
			bool tstValue = (!this._tstReport.IncludePhysicianSummary);

			this._tstReport.IncludePhysicianSummary = tstValue;

			Assert.IsTrue(this._tstReport.IncludePhysicianSummary == tstValue);
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludePhysicianSummary_Fail()
		{
		}

		[Test]
		public void IncludeSpecialtySummary_Pass()
		{
			bool tstValue = (!this._tstReport.IncludeSpecialtySummary);

			this._tstReport.IncludeSpecialtySummary = tstValue;

			Assert.IsTrue(this._tstReport.IncludeSpecialtySummary == tstValue);
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeSpecialtySummary_Fail()
		{
		}

		[Test]
		public void ReportCriteria_Pass()
		{
			string tstValue = this._tstReport.ReportCriteria;

			Assert.IsTrue(this._tstReport.ReportCriteria == tstValue);
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.ReadOnlyProperty )]
		public void ReportCriteria_Fail()
		{
		}

		
		[Test]
		public void GetCTRatioReportCount_Pass()
		{
			int tstValue = this._tstReport.GetCTRatioReportCount();

			Assert.IsTrue(tstValue >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetCTRatioReportCount_Fail()
		{
		}

		[Test]
		public void GetCTRatioReport_Pass()
		{
			this._tstReport.IncludePhysicianSummary = true;
			this._tstReport.IncludeSpecialtySummary = true;
			this._tstReport.IncludeDetailedReport = true;

			this._tstReport.GetCTRatioReport();

			Assert.IsTrue(this._tstReport.DetailedReport.Rows.Count >= 0);
			Assert.IsTrue(this._tstReport.PhysicianSummaryReport.Rows.Count >= 0);
			Assert.IsTrue(this._tstReport.SpecialtySummaryReport.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetCTRatioReport_Fail()
		{
		}

		[Test]
		public void DetailedReport_Pass()
		{
			Assert.IsTrue(this._tstReport.DetailedReport.Rows.Count >= 0);
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.ReadOnlyProperty )]
		public void DetailedReport_Fail()
		{
		}

		[Test]
		public void PhysicianSummaryReport_Pass()
		{
			this._tstReport.IncludePhysicianSummary = true;
			Assert.IsTrue(this._tstReport.PhysicianSummaryReport.Rows.Count >= 0);
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException)) ]
		public void PhysicianSummaryReport_Fail()
		{
			this._tstReport.IncludePhysicianSummary = false;
			DataTable dtTest = this._tstReport.PhysicianSummaryReport;
		}


		[Test]
		public void SpecialtySummaryReport_Pass()
		{
			this._tstReport.IncludeSpecialtySummary = true;
			Assert.IsTrue(this._tstReport.SpecialtySummaryReport.Rows.Count >= 0);
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException)) ]
		public void SpecialtySummaryReport_Fail()
		{
			this._tstReport.IncludeSpecialtySummary = false;
			DataTable dtTest = this._tstReport.SpecialtySummaryReport;
		}


		[Test]
		public void SubReportSections_Pass()
		{
			Assert.IsTrue(this._tstReport.SubReportSections.Rows.Count >= 0);
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.ReadOnlyProperty )]
		public void SubReportSections_Fail()
		{
		}

		[Test]
		public void GenerateReport_Pass()
		{
			this._tstReport.StartDate = System.DateTime.Now.AddYears(-1);
			this._tstReport.EndDate = System.DateTime.Now.AddYears(1);

			this._tstReport.IncludePhysicianSummary = true;
			this._tstReport.IncludeSpecialtySummary = true;
			this._tstReport.IncludeDetailedReport = true;
			this._tstReport.PrintedBy=Common.LogonUser.LogonUserName;
            Assert.IsTrue(this._tstReport.PrintedBy == Common.LogonUser.LogonUserName);
            //TODO: fix once Kman has migrated the report.
			//Assert.IsNotNull(this._tstReport.GenerateReport(new BOL.VbecsUser(this._tstReport.PrintedBy).UserName));
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.ReadOnlyProperty )]
		public void GenerateReport_Fail()
		{
		}

		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.CTRatioReport report = new BOL.CTRatioReport();
			Assert.AreEqual(true, report.IncludeDetailedReport, "DetailedReport" );
			Assert.AreEqual(false, report.IncludePhysicianSummary, "PhysicianSummary" );
			Assert.AreEqual(false, report.IncludeSpecialtySummary, "SpecialtySummary" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
			//Sends report to printer
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail()
		{
			//Sends report to printer
		}
	}
}

#endif
